<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Game;
use App\Models\League;
use App\Models\Team;
use Carbon\Carbon;
use Illuminate\Http\Request;

class EventController extends Controller {
    protected $pageTitle;

    protected function eventData($scope = null) {

      
        if (request()->start_time) {
            $games->DateTimeFilter('start_time');
        }

        if (request()->bet_start_time) {
            $games->DateTimeFilter('bet_start_time');
        }

        if (request()->bet_end_time) {
            $games->DateTimeFilter('bet_end_time');
        }

        $games = $games->with(['teamOne', 'teamTwo', 'league.category'])->filter(['league_id', 'team_one_id', 'team_two_id'])
            ->orderBy('id', 'desc')
            ->withCount(['questions'])
            ->paginate(getPaginate());

        $pageTitle = $this->pageTitle;

        $teamsOne = Team::rightJoin('games', 'teams.id', 'games.team_two_id')->select('teams.id', 'teams.name', 'teams.short_name')->distinct('teams.id')->get();
        $teamsTwo = Team::rightJoin('games', 'teams.id', 'games.team_one_id')->select('teams.id', 'teams.name', 'teams.short_name')->distinct('teams.id')->get();

        $teams = $teamsOne->union($teamsTwo)->unique();

        $leagues = League::whereHas('games')->get();

        return view('admin.event.index', compact('pageTitle', 'games', 'leagues', 'teams'));
    }

    public function index() {
        $this->pageTitle = 'All Games';
        return $this->gameData();
    }

 
    public function runningBets() {
        $pageTitle = 'Running Games Bets';
        //return $this->gameData('runningbets');
		return view('admin.event.running_bets', compact('pageTitle'));
    }

    public function runningeventBets() {
        $pageTitle = 'Running Event Bets';
        return view('admin.event.running_eventbets', compact('pageTitle'));
    }

    public function listcasino() {
        $pageTitle = 'Casino List';
		return view('admin.event.list_casino', compact('pageTitle'));
    }

    public function virtualcasino() {
        $pageTitle = 'Virtual Casino';
		return view('admin.event.virtual_casino', compact('pageTitle'));
    }

    public function accountlist() {
        $pageTitle = 'Account List';
		return view('admin.event.account_list', compact('pageTitle'));
    }

    public function accountcreate() {
        $pageTitle = 'Account Create';
		return view('admin.event.account_create', compact('pageTitle'));
    }

    public function accountbank() {
        $pageTitle = 'Bank Account';
		return view('admin.event.account_bank', compact('pageTitle'));
    }


}
