<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th class="text-center"><?php echo app('translator')->get('Title'); ?></th>
                                    <th><?php echo app('translator')->get('League'); ?> |<?php echo app('translator')->get('Category'); ?></th>
                                    <th><?php echo app('translator')->get('Game Starts From'); ?></th>
                                    <th><?php echo app('translator')->get('Bet Starts From'); ?></th>
                                    <th><?php echo app('translator')->get('Bet Ends At'); ?></th>
                                    <th><?php echo app('translator')->get('Markets'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $games; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $game): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center justify-content-lg-around justify-content-end gap-1">
                                                <div class="thumb" title="<?php echo e(@$game->teamOne->name); ?>">
                                                    <div class="d-flex align-items-center flex-column">
                                                        <img src="<?php echo e(@$game->teamOne->teamImage()); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                                        <?php echo e(__($game->teamOne->short_name)); ?>

                                                    </div>
                                                </div>
                                                <span> <?php echo app('translator')->get('VS'); ?></span>
                                                <div class="thumb" title="<?php echo e(@$game->teamTwo->name); ?>">
                                                    <div class="d-flex align-items-center flex-column">
                                                        <img src="<?php echo e(@$game->teamTwo->teamImage()); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                                        <?php echo e(__(@$game->teamTwo->short_name)); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <span class="fw-bold"><?php echo e(__(@$game->league->short_name)); ?></span>
                                            <br>
                                            <?php echo e(__(@$game->league->category->name)); ?>

                                        </td>

                                        <td>
                                            <em class="fw-bold"><?php echo e(showDateTime($game->start_time, 'd M, Y h:i A')); ?></em>
                                        </td>

                                        <td>
                                            <?php echo e(showDateTime($game->bet_start_time, 'd M, Y h:i A')); ?>

                                        </td>

                                        <td>
                                            <?php echo e(showDateTime($game->bet_end_time, 'd M, Y, h:i A')); ?>

                                        </td>

                                        <td><?php echo e($game->questions_count); ?></td>

                                        <td> <?php echo $game->statusBadge ?></td>

                                        <td>
                                            <div class="button--group">
                                                <a class="btn btn-sm btn-outline--primary" href="<?php echo e(route('admin.game.edit', $game->id)); ?>">
                                                    <i class="la la-pencil"></i><?php echo app('translator')->get('Edit'); ?>
                                                </a>

                                                <?php if($game->status): ?>
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn" data-action="<?php echo e(route('admin.game.status', $game->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to disable this game'); ?>?">
                                                        <i class="la la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn" data-action="<?php echo e(route('admin.game.status', $game->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to enable this game'); ?>?">
                                                        <i class="la la-eye"></i><?php echo app('translator')->get('Enable'); ?>
                                                    </button>
                                                <?php endif; ?>

                                                <a class="btn btn-sm btn-outline--info" href="<?php echo e(route('admin.question.index', $game->id)); ?>">
                                                    <i class="la la-question-circle"></i><?php echo app('translator')->get('Markets'); ?>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>

                <?php if($games->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($games)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>

    <div class="offcanvas offcanvas-end" id="offcanvasRight" aria-labelledby="offcanvasRightLabel" tabindex="-1">
        <div class="offcanvas-header">
            <h5 id="offcanvasRightLabel"><?php echo app('translator')->get('Filter by'); ?></h5>
            <button class="close bg--transparent" data-bs-dismiss="offcanvas" type="button" aria-label="Close">
                <i class="las la-times"></i>
            </button>
        </div>
        <div class="offcanvas-body">
            <form action="">
                <div class="form-group">
                    <label><?php echo app('translator')->get('Team One'); ?></label>
                    <select class="form-control select2-basic" name="team_one_id">
                        <option value=""><?php echo app('translator')->get('All'); ?></option>
                        <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($team->id); ?>" <?php if(request()->team_one_id == $team->id): echo 'selected'; endif; ?>><?php echo e($team->name); ?> - <?php echo e(@$team->short_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label><?php echo app('translator')->get('Team Two'); ?></label>
                    <select class="form-control select2-basic" name="team_two_id">
                        <option value=""><?php echo app('translator')->get('All'); ?></option>
                        <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($team->id); ?>" <?php if(request()->team_two_id == $team->id): echo 'selected'; endif; ?>><?php echo e($team->name); ?> - <?php echo e(@$team->short_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label><?php echo app('translator')->get('Leauge'); ?></label>
                    <select class="form-control select2-basic" name="league_id">
                        <option value=""><?php echo app('translator')->get('All'); ?></option>
                        <?php $__currentLoopData = $leagues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $league): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($league->id); ?>" <?php if(request()->league_id == $league->id): echo 'selected'; endif; ?>><?php echo e(__($league->name)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label><?php echo app('translator')->get('Game Started From'); ?></label>
                    <input name="start_time" type="search" class="datepicker-here form-control bg--white pe-2 date-range" placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e(request()->start_time); ?>">
                </div>
                <div class="form-group">
                    <label><?php echo app('translator')->get('Bet Started From'); ?></label>
                    <input name="bet_start_time" type="search" class="datepicker-here form-control bg--white pe-2 date-range" placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e(request()->bet_start_time); ?>">
                </div>
                <div class="form-group">
                    <label><?php echo app('translator')->get('Bet Ended At'); ?></label>
                    <input name="bet_end_time" type="search" class="datepicker-here form-control bg--white pe-2 date-range" placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e(request()->bet_end_time); ?>">
                </div>
                <div class="form-group">
                    <button class="btn btn--primary w-100 h-45"> <?php echo app('translator')->get('Filter'); ?></button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .thumb img {
            width: 30px;
            height: 30px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-sm btn-outline--info " data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" type="button" aria-controls="offcanvasRight"><i class="las la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
    <a class="btn btn-sm btn-outline--primary " href="<?php echo e(route('admin.game.create')); ?>"><i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/daterangepicker.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"

            const datePicker = $('.date-range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear'
                },
                showDropdowns: true,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 15 Days': [moment().subtract(14, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(30, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'Last 6 Months': [moment().subtract(6, 'months').startOf('month'), moment().endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                },
                maxDate: moment()
            });
            const changeDatePickerText = (event, startDate, endDate) => {
                $(event.target).val(startDate.format('MMMM DD, YYYY') + ' - ' + endDate.format('MMMM DD, YYYY'));
            }


            $('.date-range').on('apply.daterangepicker', (event, picker) => changeDatePickerText(event, picker.startDate, picker.endDate));


            if ($('.date-range').val()) {
                let dateRange = $('.date-range').val().split(' - ');
                $('.date-range').data('daterangepicker').setStartDate(new Date(dateRange[0]));
                $('.date-range').data('daterangepicker').setEndDate(new Date(dateRange[1]));
            }

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cuce22pe/public_html/bet.newgenguru.com/core/resources/views/admin/game/index.blade.php ENDPATH**/ ?>