    <div class="header-fluid-custom-parent">

        <div class="logo">
            <a href="<?php echo e(route('home')); ?>">
                <img class="img-fluid" src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('logo'); ?>">
            </a>
        </div>

        <nav class="primary-menu-container">

            <ul class="list list--row primary-menu-lg justify-content-end justify-content-lg-start">
                <?php if(Route::is('home') || Route::is('game.markets') || Route::is('league.games') || Route::is('category.games')): ?>
                    <li>
                        <a class="bet-type__live <?php if(session('game_type') != 'upcoming'): ?> active <?php endif; ?>"
                           href="/games"> <?php echo app('translator')->get('GAMES'); ?></a>
                    </li>
                    <li>
                        <a class="bet-type__live <?php if(session('game_type') != 'upcoming'): ?> active <?php endif; ?>"
                           href="<?php echo e(route('switch.type', 'live')); ?>"> <?php echo app('translator')->get('LIVE'); ?></a>
                    </li>
                    <li>
                        <a class="bet-type__upcoming <?php if(session('game_type') == 'upcoming'): ?> active <?php endif; ?>"
                           href="<?php echo e(route('switch.type', 'upcoming')); ?>"> <?php echo app('translator')->get('Upcoming'); ?> </a>
                    </li>
                <?php endif; ?>
            </ul>

            <ul class="list list--row primary-menu justify-content-end align-items-center right-side-nav gap-4">

                <?php if(!Route::is('home')): ?>
                    <li>
                        <a class="primary-menu-lg__link" href="<?php echo e(route('home')); ?>">
                            <span class="primary-menu-lg__link-text"> <?php echo app('translator')->get('Home'); ?> </span>
                        </a>
                    </li>
                <?php endif; ?>

                <li class="d-none d-lg-block">
                    <div class="select-lang--container">
                        <div class="select-lang">
                            <select class="form-select oddsType">
                                <option value="" disabled><?php echo app('translator')->get('Odds Type'); ?></option>
                                <option value="decimal" <?php if(session('odds_type') == 'decimal'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Decimal Odds'); ?></option>
                                <option value="fraction" <?php if(session('odds_type') == 'fraction'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Fraction Odds'); ?></option>
                                <option value="american" <?php if(session('odds_type') == 'american'): echo 'selected'; endif; ?>><?php echo app('translator')->get('American Odds'); ?></option>
                            </select>
                        </div>
                    </div>
                </li>
                <?php if(gs('multi_language')): ?>
                    <?php
                        $languages = App\Models\Language::all();
                        $language = $languages->where('code', '!=', session('lang'));
                        $activeLanguage = $languages->where('code', session('lang'))->first();
                    ?>
                    <li>
                        <div class="dropdown-lang dropdown mt-0">
                            <a href="#" class="language-btn dropdown-toggle" data-bs-toggle="dropdown"
                               aria-expanded="false">
                                <img class="flag" src="<?php echo e(getImage(getFilePath('language') . '/' . @$activeLanguage->image, getFileSize('language'))); ?>" alt="us">
                                <span class="language-text text-white"><?php echo e(__(@$activeLanguage->name)); ?></span>
                            </a>
                            <ul class="dropdown-menu" style="">
                                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="javascript:void(0)" class="langSel" data-code="<?php echo e($item->code); ?>">
                                            <img class="flag" src="<?php echo e(getImage(getFilePath('language') . '/' . @$item->image, getFileSize('language'))); ?>" alt="image">
                                            <?php echo e(__(@$item->name)); ?>

                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                <?php if(auth()->guard()->check()): ?>
                    <?php if(request()->routeIs('user.*')): ?>
                        <li><a class="btn btn--signup" href="<?php echo e(route('home')); ?>"> <?php echo app('translator')->get('Bet Now'); ?> </a></li>
                    <?php else: ?>
                        <li><a class="btn btn--signup" href="<?php echo e(route('user.home')); ?>"> <?php echo app('translator')->get('Dashboard'); ?> </a></li>
                    <?php endif; ?>
                <?php else: ?>
                    <?php if(request()->routeIs('user.login')): ?>
                        <?php if(gs('registration')): ?>
                            <li><a class="btn btn--signup" href="<?php echo e(route('user.register')); ?>"> <?php echo app('translator')->get('Sign up'); ?> </a></li>
                        <?php endif; ?>
                    <?php elseif(request()->routeIs('user.register')): ?>
                        <li><button class="btn btn--signup" data-bs-toggle="modal" data-bs-target="#loginModal"
                                    type="button"> <?php echo app('translator')->get('Login'); ?> </button></li>
                    <?php else: ?>
                        <li><button class="btn btn--login" data-bs-toggle="modal" data-bs-target="#loginModal"
                                    type="button"> <?php echo app('translator')->get('Login'); ?> </button></li>
                        <?php if(gs('registration')): ?>
                            <li><a class="btn btn--signup" href="<?php echo e(route('user.register')); ?>"> <?php echo app('translator')->get('Sign up'); ?> </a></li>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </ul>
        </nav>
    </div>

    <?php
        $loginContent = getContent('login.content', true);
    ?>

    <div class="modal fade login-modal" id="loginModal" data-bs-backdrop="static" data-bs-keyboard="false"
         role="dialog" aria-labelledby="modalTitleId" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body p-3 p-sm-5">
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h4 class="mt-0"><?php echo e(__(@$loginContent->data_values->heading)); ?></h4>
                    </div>
                    <?php echo $__env->make($activeTemplate . 'partials.login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
<?php /**PATH /home/cuce22pe/public_html/bet.newgenguru.com/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>