<?php
    $betData = collect(session()->get('bets'));
    $optionId = $betData->pluck('option_id')->toArray();
    $options = App\Models\Option::whereIn('id', $optionId)
        ->with(['question.game.teamOne', 'question.game.teamTwo'])
        ->get();
    $bets = $betData->zip($options);
    $totalReturn = 0;
?>

<style>
    @media (min-width: 981px) {
        .coupon-footer {
            margin: 2px 0 0;
        }
    }

    .coupon__possible-win {

        flex-direction: row !important;
    }

    .coupon-footer {
        margin: 0 !important;
    }

    @media screen and (min-width: 992px) {
        .betslip__footer-bottom {
            /* padding-left: 10px;
        padding-right: 10px; */
            padding-top: 0px;
        }
        .betTypeBtn {
            background: var(--bg-light-grey) ;
            color: hsl(var(--white)) !important;
        }
        .betTypeBtn {
            background: var(--bg-light-grey);
            color: hsl(var(--white)) !important;
        }
        .bet-type__btn bet-tab-single betTypeBtn active {
            background: hsl(var(--base)) !important;
            color: hsl(var(--white));
            border-color: hsl(var(--base));
        }
        .bet-type__btn bet-tab-multi betTypeBtn active {
            background: hsl(var(--base)) !important;
        }
    }
</style>

<div class="betslip">
    <!-- <div class="betslip__head">
        <h6 class="m-0 text-white"> <i class="fa-thin fa-clipboard-list-check"></i> <?php echo app('translator')->get('Bet Slip'); ?></h6>
    </div> -->

    <div class="list-group bet-type">
        <button class="bet-type__btn active bet-tab-single betTypeBtn" data-type="<?php echo e(Status::SINGLE_BET); ?>"
            type="button"><?php echo app('translator')->get('Single Bet'); ?></button>
        <button class="bet-type__btn bet-tab-multi betTypeBtn"
            data-type="<?php echo e(Status::MULTI_BET); ?>" type="button"><?php echo app('translator')->get('Multi Bet'); ?></button>
    </div>

    <div class="betslip__body" data-simplebar="init" style="background: var(--bg-light-grey);border:none">
        <div class="simplebar-wrapper">
            <div class="simplebar-height-auto-observer-wrapper">
                <div class="simplebar-height-auto-observer"></div>
            </div>
            <div class="simplebar-mask">
                <div class="simplebar-offset">
                    <div class="simplebar-content-wrapper" role="region" aria-label="scrollable content"
                        tabindex="0">
                        <div class="simplebar-content">
                            <ul class="list betslip__list">
                                <?php $__currentLoopData = $bets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo $__env->make($activeTemplate . 'partials.bet_slip_item', [
                                        'bet' => $bet[0],
                                        'option' => $bet[1],
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="empty-slip-message">
                                <span class="image_icon">
                                    <img src="<?php echo e(asset($activeTemplateTrue . 'images/empty_list.png')); ?>"
                                        alt="<?php echo app('translator')->get('image'); ?>">
                                </span>
                                <span class="text_content"><?php echo app('translator')->get('Your selections will be displayed here'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="simplebar-placeholder"></div>
        </div>

        <div class="simplebar-track simplebar-horizontal">
            <div class="simplebar-scrollbar"></div>
        </div>
        <div class="simplebar-track simplebar-vertical">
            <div class="simplebar-scrollbar"></div>
        </div>
    </div>

    <div class="betslip__footer" id="betSlipBody" style="background: var(--bg-light-grey);border:none">
        <ul class="list betslip__footer-list">
            <li>
                <div class="betslip__list-content">
                    <div class="betslip__list-match" style="color: white"><?php echo app('translator')->get('Singles'); ?> (x<span
                            class="bet-slip-count"><?php echo e($bets->count()); ?></span>)</div>
                    <div class="betslip__list-bet">
                        <span class="betslip__list-odd" style="color: white"><?php echo app('translator')->get('Stake Per Bet'); ?></span>
                    </div>

                </div>
                <div class="betslip-righ">
                    <div class="betslip__list-ratio">
                        <div class="coupon__odd-input-holder">
                            <input class="coupon__odd-input amount" name="total_invest" type="number"
                                autocomplete="off" step="any" placeholder="0.0" virtualkeyboardpolicy=""
                                inputmode="decimal" style="padding-left: 7px;">
                        </div>
                        <div class="coupon__possible-win-text" style="color: white"><?php echo app('translator')->get('STAKE'); ?>&nbsp;
                        </div>
                        
                        
                    </div>
                    <div class="bet-return">
                        <small class="text--danger total-stake-amount"></small>
                        <small class="text--danger total-validation-msg"></small>
                        <div class="coupon-footer">
                            <div class="coupon__possible-win">
                                <span><?php echo app('translator')->get('Returns'); ?>: <?php echo e(gs('cur_sym')); ?>

                                    <span class="total-return-amount"><?php echo e(getAmount($totalReturn)); ?></span>
                                </span>
                                
                            </div>
                        </div>



                        
                    </div>
                </div>
            </li>
        </ul>
        <div class="betslip__footer-bottom d-flex align-items-center" style="margin-top: 0">
            <input class="form-control form--control betslip-form" type="number" placeholder="<?php echo app('translator')->get('Enter Amount'); ?>">
            <button class="delete-btn deleteAll"> <i class="las la-trash-alt"></i></button>
            <div class="place-btn">
                <button class="btn btn--base btn--md sm-text betslip__footer-btn bet-place-btn betPlaceBtn" style="color: white; background: var(--bs-secondary)) "
                    type="button">
                    <?php echo app('translator')->get('Place Bet'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<?php if(auth()->guard()->check()): ?>
    <div class="modal fade custom--modal" id="betModal" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirmation Alert'); ?></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form id="betForm" action="<?php echo e(route('user.bet.place')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input name="stake_amount" type="hidden">
                        <input name="type" type="hidden">
                        <p><?php echo app('translator')->get('Are you sure to place bet'); ?>?</p>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('No'); ?></button>
                        <button class="btn btn--base" type="submit"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/skeleton.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            let betType;
            let stakeAmount;
            let totalStakeAmount;
            let auth = Number("<?php echo e(auth()->user() ? 1 : 0); ?>");
            let multiBet = Number("<?php echo e(Status::MULTI_BET); ?>");
            let singleBet = Number("<?php echo e(Status::SINGLE_BET); ?>");

            initBetType();
            totalStakeInput();
            betReturnAmount();
            showEmptyMessage()

            function showEmptyMessage() {
                if (Number($('.betslip__list li').length)) {
                    $('.empty-slip-message').hide();
                } else {
                    $('.empty-slip-message').show();
                }
            }

            function initBetType() {
                betType = sessionStorage.getItem('type');
                if (!betType) {
                    betType = singleBet;
                    sessionStorage.setItem('type', betType);
                }
                $('.bet-type').find('.betTypeBtn').removeClass('active');
                $('.bet-type').find(`.betTypeBtn[data-type="${betType}"]`).addClass('active');
                controlStakeInputFields();
            }

            function controlStakeInputFields() {
                if (betType == multiBet) {
                    $('.betslip__list li .betslip-right').hide();
                    $('.betslip__list-odd').hide();

                } else {
                    $('.betslip__list li .betslip-right').show();
                    $('.betslip__list-odd').show();
                }
            }

            function betSlipCount() {
                let totalBetSlipData = $('.betslip__list li').length;

                if (!totalBetSlipData) {
                    sessionStorage.removeItem('total_stake_amount');
                    totalStakeInput();
                    showEmptyMessage();
                    return 0;
                }
                return totalBetSlipData;
            }

            function setStakeAmount(amount = 0) {
                $('.investAmount').each(function(index) {
                    $(this).val(amount);
                    let odd = Number($(this).closest('li').data('option_odds'));
                    $(this).closest('.betslip-right').find('.bet-return-amount').text(Math.abs(amount * odd)
                        .toFixed(2))
                });
            }

            function totalStakeInput(totalStakeAmount = 0) {
                totalStakeAmount = sessionStorage.getItem('total_stake_amount');
                $('[name=total_invest]').val(totalStakeAmount);
            }

            function totalMultiBetReturnAmount() {
                let totalMultiBetReturnAmount = $('[name=total_invest]').val();
                let multiBetOdd = 1;
                $('.betslip__list li').each(function(index) {
                    var odd = $(this).data('option_odds');
                    multiBetOdd *= odd;
                });
                $('.total-return-amount').text(Math.abs(totalMultiBetReturnAmount * multiBetOdd).toFixed(2));
            }

            function totalSingleBetReturnAmount() {
                let totalSingleBetReturnAmount = 0;
                $('.investAmount').each(function(index) {
                    var odd = Number($(this).closest('li').data('option_odds'));
                    totalSingleBetReturnAmount += Number($(this).val()) * odd;
                });
                $('.total-return-amount').text(Math.abs(totalSingleBetReturnAmount).toFixed(2));
            }

            function betReturnAmount() {
                betType == multiBet ? totalMultiBetReturnAmount() : totalSingleBetReturnAmount();
            }

            function showTotalBetSlipCount(count = 0) {
                $('.bet-slip-count').text(count);
                $('.bet-count').text(count);
            }

            function skeleton(type) {
                let loader = `<li class="loading">
                                    <button class="betslip__list-close"></button>
                                    <div class="betslip__list-content">
                                        <span class="betslip__list-match"></span>
                                        <span class="betslip__list-team"></span>
                                        <span class="betslip__list-question"></span>
                                        <div class="betslip__list-text"></div>
                                    </div>
                                    <div class="betslip-right">
                                        <div class="betslip__list-ratio">
                                            <span></span>
                                        </div>
                                        <span class="betslip-return"></span>
                                    </div>
                                </li>`;
                $('.betslip__list').append(loader);

                if (type == 'show') {
                    $(document).find('.loading').show();
                } else {
                    $(document).find('.loading').remove();
                }
            }


            function removeSessionTotalStakeAmount() {
                if (sessionStorage.getItem('total_stake_amount')) {
                    sessionStorage.removeItem('total_stake_amount');
                }
            }

            $(document).on('click', '.oddBtn', function() {
                let button = $(this);
                if ($(this).hasClass('active')) {
                    removeBet(button);
                    return;
                }

                $('.empty-slip-message').hide();

                skeleton('show');

                let data = {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: $(this).data('option_id'),
                    type: betType
                }

                if (betType == singleBet) {
                    data.amount = sessionStorage.getItem('total_stake_amount');
                }

                $.get(`<?php echo e(route('bet.slip.add')); ?>`, data,
                    function(response) {
                        if (response.error) {
                            skeleton('hide');
                            $('.empty-slip-message').show();
                            notify('error', response.error);
                        } else {
                            button.addClass('active');
                            setTimeout(() => {
                                skeleton('hide');
                                $('.betslip__list').append(response);
                                controlStakeInputFields();
                                showTotalBetSlipCount(betSlipCount())
                                betReturnAmount();
                            }, 500);
                        }
                    }
                );
            });

            $(document).on('input focusout', '.investAmount', function(event) {
                $('.total-validation-msg').text('');
                $('.total-stake-amount').text('');
                $('.betslip__list li').find('.validation-msg').text('')

                stakeAmount = Number($(this).val());
                if (!stakeAmount) {
                    return;
                }

                let odd = Number($(this).closest('li').data('option_odds'));
                $(this).closest('.betslip-right').find('.bet-return-amount').text(Math.abs(stakeAmount * odd)
                    .toFixed(2))


                if (event.type == 'focusout') {
                    let data = {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: $(this).closest('li').data('option_id'),
                        amount: stakeAmount
                    }
                    $.ajax({
                        type: "POST",
                        url: `<?php echo e(route('bet.slip.update')); ?>`,
                        data: data,
                        success: function(response) {

                            if (betType == singleBet) {
                                var isInvestAmountSame = false;
                                var firstInvestAmountValue = $('.investAmount').first().val();
                                if (betSlipCount() > 1) {
                                    $('.investAmount').each(function(index) {
                                        var currentInvestAmountValue = $(this).val();
                                        if (currentInvestAmountValue &&
                                            currentInvestAmountValue ==
                                            firstInvestAmountValue) {
                                            isInvestAmountSame = true;
                                        } else {
                                            isInvestAmountSame = false;
                                        }
                                    });
                                }
                                if (isInvestAmountSame) {
                                    $('[name=total_invest]').val(firstInvestAmountValue)
                                    sessionStorage.setItem('total_stake_amount',
                                        firstInvestAmountValue);
                                } else {
                                    removeSessionTotalStakeAmount();
                                    totalStakeInput();
                                }
                            } else {
                                removeSessionTotalStakeAmount();
                                totalStakeInput();
                            }
                            betReturnAmount();
                        }
                    });
                }
            });


            $(document).on('click', '.removeFromSlip', function() {
                removeBet($(this));
            });

            function removeBet(button) {
                $('.total-validation-msg').text('');
                $('.total-stake-amount').text('');
                $('.betslip__list li').find('.validation-msg').text('')
                let id = button.data('option_id');
                let data = {
                    _token: '<?php echo e(csrf_token()); ?>'
                };
                $.post(`<?php echo e(route('bet.slip.remove', '')); ?>/${id}`, data,
                    function(response) {
                        if (response.status == 'success') {
                            $(document).find(`.oddBtn[data-option_id="${id}"]`).removeClass('active');
                            $(document).find(`.removeFromSlip[data-option_id="${id}"]`).parent().remove();
                            showTotalBetSlipCount(betSlipCount())
                            betReturnAmount();
                        }
                    }
                );
            }

            $('.betTypeBtn').on('click', function() {
                betType = Number($(this).data('type'));
                if ($(this).hasClass('active')) {
                    return;
                }

                $('.total-validation-msg').text('');
                $('.total-stake-amount').text('');
                $('.betslip__list li').find('.validation-msg').text('')

                sessionStorage.setItem('type', betType);

                $(`.betTypeBtn`).removeClass('active');
                $(this).addClass('active');
                stakeAmount = sessionStorage.getItem('total_stake_amount');

                if (stakeAmount && betType == singleBet) {
                    setStakeAmount(stakeAmount);
                    let totalSingleStakeAmount = 0;
                    $('.investAmount').each(function(index) {
                        if (!$(this).val()) {
                            $(this).closest('.betslip-right').find('.validation-msg').text(
                                `<?php echo app('translator')->get('Stake is required'); ?>`);
                        } else {
                            totalSingleStakeAmount += Number($(this).val());
                        }
                    });
                    if (totalSingleStakeAmount) {
                        stakeLimitValidation(totalSingleStakeAmount)
                    }
                } else {
                    totalStakeInput(stakeAmount);
                    if (stakeAmount) {
                        stakeLimitValidation(stakeAmount);
                    }
                }
                controlStakeInputFields();
                betReturnAmount();
            });

            $('.deleteAll').on('click', function() {
                let data = {
                    _token: '<?php echo e(csrf_token()); ?>'
                };
                $.post(`<?php echo e(route('bet.slip.remove.all', '')); ?>`, data,
                    function(response) {
                        if (response.status == 'success') {
                            $('.betslip__list li').remove();
                            $('.oddBtn').removeClass('active');
                            showTotalBetSlipCount(betSlipCount());
                            betReturnAmount();
                        }
                    }
                );
            })

            $('[name=total_invest]').on('input focusout', function(event) {

                $('.total-validation-msg').text('');
                $('.total-stake-amount').text('');
                $('.betslip__list li').find('.validation-msg').text('');


                totalStakeAmount = Number($(this).val());
                if (!totalStakeAmount) {
                    let hasValue = false;
                    $('.investAmount').each(function(index) {
                        if ($(this).val()) {
                            hasValue = true;
                        }
                    });
                    if (hasValue) {
                        removeSessionTotalStakeAmount();
                    }
                    return;
                } else {
                    sessionStorage.setItem('total_stake_amount', totalStakeAmount);
                    setStakeAmount(Number($(this).val()));
                    betReturnAmount();
                }

                if (event.type == 'focusout') {
                    let data = {
                        _token: '<?php echo e(csrf_token()); ?>',
                        amount: totalStakeAmount,
                    }
                    $.ajax({
                        type: "POST",
                        url: `<?php echo e(route('bet.slip.update.all')); ?>`,
                        data: data,
                        success: function(response) {
                            $('.total-validation-msg').text('');
                        }
                    });
                }

            })

            $('.betPlaceBtn').on('click', function(e) {
                let error = false;
                let message = '';
                let totalBetCount = betSlipCount();
                let finalStakeAmount = 0;

                if (betType == multiBet && totalBetCount < 2) {
                    notify('error', "Minimum of two bets are required for multi bet");
                    return;
                }

                if (betType == multiBet) {
                    finalStakeAmount = Number($('[name=total_invest]').val());
                    if (!finalStakeAmount) {
                        $('.total-validation-msg').text(`<?php echo app('translator')->get('Stake amount is required'); ?>`);
                        return;
                    }

                } else {
                    if (!totalBetCount) {
                        notify('error', "Your bet slip is empty");
                        return;
                    }
                    finalStakeAmount = 0;

                    $('.investAmount').each(function(index) {
                        if (!$(this).val()) {
                            $(this).closest('.betslip-right').find('.validation-msg').text(
                                `<?php echo app('translator')->get('Stake is required'); ?>`);
                            error = true;
                        } else {
                            finalStakeAmount += Number($(this).val());
                        }
                    });

                    if (error) {
                        return;
                    }
                }

                let stakeLimit = stakeLimitValidation(finalStakeAmount);
                if (stakeLimit) {
                    return;
                }

                stakeAmount = finalStakeAmount;
                if (auth) {
                    var modal = $("#betModal");
                    modal.find('[name=stake_amount]').val(finalStakeAmount);
                    modal.find('[name=type]').val(betType);
                } else {
                    var modal = $("#loginModal");
                    var html = `<input type="hidden" name="location" value=${window.location.href}/>`;
                    modal.find('.input--group').prepend(html);
                }
                modal.modal('show');
            });

            function stakeLimitValidation(finalAmount) {
                let minLimit = betType == singleBet ? Number("<?php echo e(getAmount(gs('single_bet_min_limit'))); ?>") : Number(
                    "<?php echo e(getAmount(gs('multi_bet_min_limit'))); ?>");
                let maxLimit = betType == singleBet ? Number("<?php echo e(getAmount(gs('single_bet_max_limit'))); ?>") : Number(
                    "<?php echo e(getAmount(gs('multi_bet_max_limit'))); ?>");
                if (finalAmount < minLimit) {
                    $('.total-stake-amount').text(`Total stake <?php echo e(gs('cur_sym')); ?>${finalAmount}`)
                    $('.total-validation-msg').text(`Min stake limit <?php echo e(gs('cur_sym')); ?>${minLimit}`);
                    return true;
                }

                if (finalAmount > maxLimit) {
                    $('.total-stake-amount').text(`Total stake <?php echo e(gs('cur_sym')); ?>${finalAmount}`)
                    $('.total-validation-msg').text(`Max stake limit <?php echo e(gs('cur_sym')); ?>${maxLimit}`);
                    return true;
                }
                return false;
            }

            $('#betForm').on('submit', function(e) {
                sessionStorage.removeItem('total_stake_amount');
                return true;
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/cuce22pe/public_html/bet.newgenguru.com/core/resources/views/templates/basic/partials/bet_slip.blade.php ENDPATH**/ ?>