<?php $__env->startSection('panel'); ?>
    <div class="row gy-4">
        <div class="col-xxl-4">
            <div class="card">

                <div class="card-header d-flex justify-content-between flex-wrap">
                    <h5><?php echo app('translator')->get('Game Info'); ?></h5>
                    <div><?php echo $game->statusBadge;?></div>
                </div>

                <div class="card-body">
                    <div class="d-flex justify-content-center align-items-center mb-3 flex-wrap gap-2">
                        <div class="team-logo">
                            <span><?php echo e(__(@$game->teamOne->short_name)); ?></span>
                            <img src="<?php echo e(getImage(getFilePath('team') . '/' . $game->teamOne->image, getFileSize('league'))); ?>" alt="image">
                        </div>
                        <span class="px-2"><?php echo app('translator')->get('VS'); ?></span>
                        <div class="team-logo">
                            <img src="<?php echo e(getImage(getFilePath('team') . '/' . $game->teamTwo->image, getFileSize('league'))); ?>" alt="image">
                            <span><?php echo e(__(@$game->teamTwo->short_name)); ?></span>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between mb-3 flex-wrap gap-3">
                        <div>
                            <small class="text-muted"> <?php echo app('translator')->get('League'); ?></small>
                            <h6 class="f-size-16px"> <?php echo e(__(@$game->league->name)); ?></h6>
                        </div>

                        <div class="text-end">
                            <small class="text-muted"> <?php echo app('translator')->get('Category'); ?></small>
                            <h6 class="f-size-16px"> <?php echo e(__(@$game->league->category->name)); ?></h6>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between flex-wrap gap-3">
                        <div>
                            <small class="text-muted"> <?php echo app('translator')->get('Betting Starts From'); ?></small>
                            <h6 class="f-size-16px"> <?php echo e(showDateTime($game->bet_start_time, 'd M Y, h:i A')); ?></h6>
                        </div>

                        <div class="text-end">
                            <small class="text-muted"> <?php echo app('translator')->get('Betting Ends At'); ?></small>
                            <h6 class="f-size-16px"> <?php echo e(showDateTime($game->bet_end_time, 'd M Y, h:i A')); ?></h6>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-xxl-8">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Markets'); ?></th>
                                    <th><?php echo app('translator')->get('Options'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(strLimit(__($question->title), 40)); ?></td>
                                        <td><?php echo e($question->options->count()); ?></td>
                                        <td> <?php echo $question->statusBadge ?> </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-outline--primary btn-sm cuModalBtn" data-resource="<?php echo e($question); ?>" data-modal_title="<?php echo app('translator')->get('Edit Market'); ?>" type="button">
                                                    <i class="la la-pencil"></i><?php echo app('translator')->get('Edit'); ?>
                                                </button>

                                                <button class="btn btn-outline--info btn-sm option-btn" data-resource="<?php echo e($question); ?>" data-game_upcoming="<?php echo e(!$question->result && !$game->isUpcoming); ?>" data-game_expired="<?php echo e(!$question->result && !$game->isExpired); ?>" type="button">
                                                    <i class="la la-list-ol"></i><?php echo app('translator')->get('Options'); ?>
                                                </button>

                                                <?php if($question->status): ?>
                                                    <button class="btn btn-outline--danger btn-sm confirmationBtn" data-action="<?php echo e(route('admin.question.status', $question->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to disable this market'); ?>?">
                                                        <i class="la la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="btn btn-outline--success btn-sm confirmationBtn" data-action="<?php echo e(route('admin.question.status', $question->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to enable this market'); ?>?">
                                                        <i class="la la-eye"></i><?php echo app('translator')->get('Enable'); ?>
                                                    </button>
                                                <?php endif; ?>

                                                <?php if($question->locked): ?>
                                                    <button class="btn btn-outline--success btn-sm confirmationBtn" data-action="<?php echo e(route('admin.question.locked', $question->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to unlock this market'); ?>?">
                                                        <i class="las la-unlock"></i> <?php echo app('translator')->get('Unlock'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="btn btn-outline--dark btn-sm confirmationBtn" data-action="<?php echo e(route('admin.question.locked', $question->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to lock this market'); ?>?">
                                                        <i class="las la-lock"></i> <?php echo app('translator')->get('Lock'); ?>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($questions->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($questions)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="cuModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.question.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input name="game_id" type="hidden" value="<?php echo e($game->id); ?>">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Title'); ?></label>
                                    <input class="form-control" name="title" type="text" value="<?php echo e(old('title')); ?>" required />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    

    <div class="modal" id="optionModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
                        <div class="game-area d-flex align-items-center">
                            <div class="team-logo">
                                <span><?php echo e(__(@$game->teamOne->short_name)); ?></span>
                                <img src="<?php echo e(getImage(getFilePath('team') . '/' . @$game->teamOne->image, getFileSize('league'))); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <span class="px-2">
                                <?php echo app('translator')->get('VS'); ?>
                            </span>
                            <div class="team-logo">
                                <img src="<?php echo e(getImage(getFilePath('team') . '/' . @$game->teamTwo->image, getFileSize('league'))); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                <span><?php echo e(__(@$game->teamTwo->short_name)); ?></span>
                            </div>
                        </div>

                        <div class="result-area"></div>

                        <?php if(!@$game->isExpired): ?>
                            <div class="action-area"></div>
                        <?php endif; ?>
                    </div>
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Option'); ?></th>
                                    <th><?php echo app('translator')->get('Rate'); ?></th>
                                    <th><?php echo app('translator')->get('Bet Count'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <?php if(!@$game->isExpired): ?>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal" id="optionStoreModal" data-bs-backdrop="static" data-bs-keyboard="false" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close close-option-modal" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form id="optionStore" action="" method="POST">
                    <div class="modal-body">
                        <input name="question_id" type="hidden">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Option'); ?></label>
                            <input class="form-control" name="name" type="text" value="<?php echo e(old('name')); ?>" required />
                        </div>

                        <div class="form-group mb-0">
                            <label><?php echo app('translator')->get('Rate in Decimal Odds'); ?></label>
                            <input class="form-control" name="odds" type="number" value="<?php echo e(old('odds')); ?>" step="any" required />
                            <small class="text--info text--small"><i class="la la-info-circle"></i> <?php echo app('translator')->get('Default odds type is decimal'); ?></small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal" id="optionStatusModal" data-bs-backdrop="static" data-bs-keyboard="false" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirmation Alert!'); ?></h5>
                    <button class="close close-option-modal" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form id="optionStatusForm" action="" method="POST">
                    <div class="modal-body">
                        <p class="question"></p>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark close-option-modal" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('No'); ?></button>
                        <button class="btn btn--primary" type="submit"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.back','data' => ['route' => ''.e(route('admin.game.index')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['route' => ''.e(route('admin.game.index')).'']); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $attributes = $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $component = $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
    <button class="btn btn-sm btn-outline--primary cuModalBtn" data-modal_title="<?php echo app('translator')->get('Add New Market'); ?>" type="button">
        <i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?>
    </button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .f-size-16px {
            font-size: 14px !important;
        }

        @media(min-width:768px) {
            .button--group button {
                width: 100px;
            }
        }

        .team-logo img {
            width: 35px;
            height: 35px;
            border-radius: 50%;
            padding: 3px;
            box-shadow: 0 0 10px 0px #ddd;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/cu-modal.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            let modal = $("#optionModal");

            function optionTable(options) {
                var isExpired = "<?php echo e($game->isExpired); ?>";
                var tableRow = ``;
                if (!options.length) {
                    tableRow = `<tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>`
                }
                $.each(options, function(index, option) {
                    tableRow += `<tr>
                                    <td data-label="<?php echo app('translator')->get('Option'); ?>">${option.locked ? `<span class="text--danger"><i class="las la-lock"></i></span>` : ''}${option.name}</td>
                                    <td data-label="<?php echo app('translator')->get('Rate'); ?>">${Number(option.odds)}</td>
                                    <td data-label="<?php echo app('translator')->get('Bet Count'); ?>">${option.bets_count}</td>
                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    ${option.status == 1 ?
                                        `<span class="badge badge--success"><?php echo app('translator')->get('Enabled'); ?></span>` :
                                        `<span class="badge badge--danger"><?php echo app('translator')->get('Disabled'); ?></span>`
                                    }
                                    </td>
                                    ${isExpired ? `` :
                                    `<td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <div class="button--group option-button-group">
                                        <button type="button" class="btn btn-sm btn-outline--primary edit-option" data-resource='${JSON.stringify(option)}'><i class="la la-pencil"></i><?php echo app('translator')->get('Edit'); ?></button>
                                        ${option.status == 1 ?`<button class="btn btn-sm btn-outline--danger option-status-btn" data-action="<?php echo e(route('admin.option.status', '')); ?>/${option.id}" data-question="<?php echo app('translator')->get('Are you sure to disable this option'); ?>?"><i class="la la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?></button>` : `<button class="btn btn-sm btn-outline--success option-status-btn" data-action="<?php echo e(route('admin.option.status', '')); ?>/${option.id}" data-question="<?php echo app('translator')->get('Are you sure to enable this option'); ?>?"><i class="la la-eye"></i><?php echo app('translator')->get('Enable'); ?></button>`} ${option.locked == 1 ?`<button class="btn btn-sm btn-outline--success option-status-btn" data-action="<?php echo e(route('admin.option.locked', '')); ?>/${option.id}" data-question="<?php echo app('translator')->get('Are you sure to unlock this option'); ?>?">
                                                <i class="las la-unlock"></i> <?php echo app('translator')->get('Unlock'); ?>
                                            </button>` : `<button class="btn btn-sm btn-outline--dark option-status-btn" data-action="<?php echo e(route('admin.option.locked', '')); ?>/${option.id}" data-question="<?php echo app('translator')->get('Are you sure to lock this option'); ?>?">
                                                <i class="las la-lock"></i> <?php echo app('translator')->get('Lock'); ?>
                                            </button>`} </div></td>`}</tr>`
                });
                return tableRow;
            }

            $('.option-btn').on('click', function(e) {
                modal.find('tbody').html('')
                var question = $(this).data('resource');

                var modalTitle = `Option for - ${question.title}`;
                modal.find('.modal-title').text(modalTitle);
                modal.find('tbody').html('');
                var tableRow = optionTable(question.options);
                modal.find('tbody').html(tableRow)

                var actionBtn = `<div class="button--group m-0">
                                        <button class="btn btn-sm btn-outline--primary add-option" data-question_id="${question.id}" data-modal_title="<?php echo app('translator')->get('Add New Option'); ?>" type="button">
                                            <i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?>
                                        </button>
                                </div>`;
                modal.find('.action-area').html(actionBtn);

                if (question.options.length) {
                    var result = ``;
                    if (!question.result) {
                        result =
                            `<span class="text--small"><?php echo app('translator')->get('Result'); ?> : </span><span class="text--small badge badge--warning"><?php echo app('translator')->get('Undeclared'); ?></span>`
                    } else if (question.result && question.lose) {
                        result =
                            `<span class="text--small"><?php echo app('translator')->get('Result'); ?> : </span><span class="text--small badge badge--success"><?php echo app('translator')->get('Lose'); ?></span>`
                    } else if (question.result && question.refund) {
                        result =
                            `<span class="text--small"><?php echo app('translator')->get('Result'); ?> : </span><span class="text--small badge badge--primary"><?php echo app('translator')->get('Refunded'); ?></span>`
                    } else {
                        result =
                            `<span class="text--small"><?php echo app('translator')->get('Result'); ?> : </span><span class="text--small badge badge--success"><?php echo app('translator')->get('Declared'); ?></span>`
                    }
                }
                modal.find('.result-area').html(result);
                modal.modal('show')
            });

            let optionStoreModal = $("#optionStoreModal");
            $(document).on('click', '.add-option', function(e) {
                optionStoreModal.find('.modal-title').text('Add New Option');
                optionStoreModal.find('form').attr('action', `<?php echo e(route('admin.option.store', '')); ?>`)
                optionStoreModal.find('[name=question_id]').val($(this).data('question_id'));
                optionStoreModal.modal('show');
                modal.modal('hide');
            });

            $(document).on('click', '.edit-option', function() {
                var data = $(this).data('resource');
                optionStoreModal.find('.modal-title').text('Update Option');
                optionStoreModal.find('form').attr('action',
                    `<?php echo e(route('admin.option.store', '')); ?>/${data.id}`)
                optionStoreModal.find('[name=question_id]').val(data.question_id);
                optionStoreModal.find('[name=name]').val(data.name);
                optionStoreModal.find('[name=odds]').val(Math.abs(data.odds));
                optionStoreModal.modal('show');
                modal.modal('hide');
            })

            optionStoreModal.on('hidden.bs.modal', function() {
                $('#optionStoreModal form')[0].reset();
            });

            $(document).on('click', '.close-option-modal', function() {
                modal.modal('show')
            });

            $(document).on('submit', '#optionStore', function(event) {
                event.preventDefault();
                let data = {
                    _token: '<?php echo e(csrf_token()); ?>',
                    name: $(this).find('[name=name]').val(),
                    odds: $(this).find('[name=odds]').val(),
                    question_id: $(this).find('[name=question_id]').val()
                };
                var action = $(this).attr('action')
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: data,
                    success: function(response) {
                        if (response.error) {
                            notify('error', response.error);
                        } else {
                            modal.find('tbody').html('');
                            var tableRow = optionTable(response.options);
                            modal.find('tbody').html(tableRow)
                            optionStoreModal.modal('hide')
                            modal.modal('show')
                            notify('success', response.success);
                        }
                    }
                });
            });

            let optionStatusModal = $("#optionStatusModal");

            $(document).on('click', '.option-status-btn', function() {
                modal.modal('hide');
                let data = $(this).data();
                optionStatusModal.find('.question').text(`${data.question}`);
                optionStatusModal.find('form').attr('action', `${data.action}`);
                optionStatusModal.modal('show');
            })
            $(document).on('submit', '#optionStatusForm', function(event) {
                event.preventDefault();
                let data = {
                    _token: '<?php echo e(csrf_token()); ?>',
                };
                var action = $(this).attr('action')
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: data,
                    success: function(response) {
                        if (response.error) {
                            notify('error', response.error);
                        } else {
                            modal.find('tbody').html('');
                            var tableRow = optionTable(response.options);
                            modal.find('tbody').html(tableRow)
                            optionStatusModal.modal('hide')
                            modal.modal('show')
                            notify('success', response.success);
                        }
                    }
                });
            })
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cuce22pe/public_html/bet.newgenguru.com/core/resources/views/admin/game/question.blade.php ENDPATH**/ ?>