    <?php
        $gameType = session('game_type', 'live');
    ?>
  

    <nav class="sports-category" data-simplebar>
        <div class="sports-category__list active accordion-container">
            <a class="sports-category__link" href="/">
                <span class="sports-category__icon">
                    <i class="discipline-icon _top-pro" style="background: none"></i>
                </span>
                <span class="sports-category__text">
                    Home
                </span>               
            </a>
            
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a class="sports-category__link <?php if(isset($activeCategory[0]->id) && $activeCategory[0]->id == $category->id): ?> active <?php endif; ?>"
                    href="<?php echo e(route('category.games', $category->slug)); ?>">

                    <?php if($category->games_count): ?>
                        <span class="sports-category__notification"> <?php echo e($category->games_count); ?> </span>
                    <?php endif; ?>
                    <span class="sports-category__icon">
                        <?php echo $category->icon ?>
                    </span>
                    <span class="sports-category__text">
                        <?php echo e(strLimit(__($category->name), 20)); ?>

                    </span>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <h3>Sports</h3>
            <a class="sports-category__link accordian_anchor" href="javascript:void()">
                <span class="sports-category__icon">
                    <i class="discipline-icon _american-football" style="background: none"></i>
                </span>
                <span class="sports-category__text">
                    American Footbal
                </span>
                <span class="toggle-icon">+</span>
            </a>
            <div class="accordian_div">
                <ul>
                    <li><img src=".././assets/images/6517.png" /> <span class="submenu_text">USA. NFL</span></li>
                    <li><img src=".././assets/images/6553.png" /> <span class="submenu_text">USA. NCAA</span></li>
                    <li><img src=".././assets/images/7268.png" /> <span class="submenu_text">Canada. CFL</span></li>
                </ul>
            </div>

             <a class="sports-category__link accordian_anchor" href="javascript:void()">
                <span class="sports-category__icon">
                    <i class="discipline-icon _baseball" style="background: none"></i>
                </span>
                <span class="sports-category__text">
                    Baseball
                </span>
                <span class="toggle-icon">+</span>
            </a>
            <div class="accordian_div">
                <ul>
                    <li><img src=".././assets/images/6517.png" /> <span class="submenu_text">USA. NFL</span></li>
                    <li><img src=".././assets/images/6553.png" /> <span class="submenu_text">USA. NCAA</span></li>
                    <li><img src=".././assets/images/7268.png" /> <span class="submenu_text">Canada. CFL</span></li>
                </ul>
            </div>

        </div>
    </nav>

   

    <script>
    document.querySelectorAll('.accordian_anchor').forEach(anchor => {
        anchor.addEventListener('click', () => {
            const nextAccordion = anchor.nextElementSibling;
            const icon = anchor.querySelector('.toggle-icon');
            const isOpen = nextAccordion.classList.contains('active');
            
            // Close all accordions and reset icons
            document.querySelectorAll('.accordian_div').forEach(div => {
                div.classList.remove('active');
                div.style.maxHeight = null;
            });
            document.querySelectorAll('.accordian_anchor').forEach(link => link.classList.remove('active'));
            document.querySelectorAll('.toggle-icon').forEach(icon => icon.textContent = '+');
            
            // Open the clicked accordion and add active class if it was closed
            if (!isOpen) {
                nextAccordion.classList.add('active');
                nextAccordion.style.maxHeight = nextAccordion.scrollHeight + 'px';
                anchor.classList.add('active');
                icon.textContent = '-';
            }
        });
    });
</script>

 <style>
        

        .accordian_div {          
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out, padding 0.3s ease-out;
        }
        .accordian_div ul li{
            padding: 6px 30px 6px 20px;
            color: #8E949F;
            font-size: 13px;
            line-height: 14px;
            font-family: 'Rubik';
        }
        .sports-category__link.accordian_anchor.active{
            background: #282F3E;
        }
        .accordian_div.active{
            background: #282F3E;
            margin-top: -1px;
        }
    </style>
<?php /**PATH /home/cuce22pe/public_html/bet.newgenguru.com/core/resources/views/templates/basic/partials/category.blade.php ENDPATH**/ ?>